/*******************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Tasks.h
\brief      Tasks to be assigned to each execution thread of Task scheduler.
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     R01160
\version    0.1
\date       21/May/2008
*/
/*******************************************************************************/
/*                                                                             */
/* All software, source code, included documentation, and any implied know-how */
/* are property of Freescale Semiconductor and therefore considered            */ 
/* CONFIDENTIAL INFORMATION.                                                   */
/*                                                                             */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY. */
/*                                                                             */
/* All Confidential Information remains the property of Freescale Semiconductor*/
/* and will not be copied or reproduced without the express written permission */
/* of the Discloser, except for copies that are absolutely necessary in order  */
/* to fulfill the Purpose.                                                     */
/*                                                                             */
/* Services performed by FREESCALE in this matter are performed AS IS and      */
/* without any warranty. CUSTOMER retains the final decision relative to the   */
/* total design and functionality of the end product.                          */
/*                                                                             */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the    */
/* success of this project.                                                    */
/*                                                                             */
/* FREESCALE disclaims all warranties, express, implied or statutory including,*/
/* but not limited to, implied warranty of merchantability or fitness for a    */
/* particular purpose on any hardware, software ore advise supplied to the     */
/* project by FREESCALE, and or any product resulting from FREESCALE services. */
/*                                                                             */
/* In no event shall FREESCALE be liable for incidental or consequential       */
/* damages arising out of this agreement. CUSTOMER agrees to hold FREESCALE    */
/* harmless against any and all claims demands or actions by anyone on account */
/* of any damage,or injury, whether commercial, contractual, or tortuous,      */
/* rising directly or indirectly as a result of the advise or assistance       */
/* supplied CUSTOMER in connectionwith product, services or goods supplied     */
/* under this Agreement.                                                       */
/*                                                                             */
/*******************************************************************************/

#ifndef __TASKS
#define __TASKS

/*-- Includes ----------------------------------------------------------------*/
#include "Derivative.h"

/*-- Types Definitions -------------------------------------------------------*/
extern uint8_t  gu8Index;
/*-- Defines -----------------------------------------------------------------*/


/*-- Macros ------------------------------------------------------------------*/

/** List of tasks to be executed @ 10ms */
#define EXECUTE_10MS_TASKS()                               \
{                                                          \
   SIU.GPDO[16].R ^= 1;                                    \
   vfnAdc_Sample_Acquire();                                \
}  

/** List of tasks to be executed @ 20ms */
#define EXECUTE_20MS_TASKS()                               \
{                                                          \
  SIU.GPDO[17].R ^= 1;                                     \
}  

/** List of tasks to be executed @ 40ms */
#define EXECUTE_40MS_TASKS()                                                       \
{                                                          \
  SIU.GPDO[18].R ^= 1;                                     \
}  

/** List of tasks to be executed @ 80ms, first group */
#define EXECUTE_80MS_A_TASKS()  \
{                                                          \
  SIU.GPDO[19].R ^= 1;                                     \
}  
  
/* List of tasks to be executed @ 2ms, second group */
#define EXECUTE_80MS_B_TASKS()   \
{;}       


/*============================================================================*/
#endif /*__TASKS */
